package jadean.ui.java.wizards;

import jadean.dean.Resource;
import jadean.dean.java.utilities.JavaUtilities;

import java.util.Arrays;
import java.util.Collection;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;


class AllResourcesLabelProvider implements ITableLabelProvider, ITableFontProvider {

	private Resource[] usedResources;
	private final Font bold = JFaceResources.getFontRegistry().getBold(JFaceResources.DIALOG_FONT);

	public AllResourcesLabelProvider() {
	}

	public void setUsedResources(Resource[] usedResources) {
		this.usedResources = usedResources;
	}

	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

	public Font getFont(Object element, int columnIndex) {
		if (element instanceof Resource) {
			Resource r = (Resource) element;
			if (JavaUtilities.inArray(usedResources, r)) {
				return bold;
			}
		}
		return null;
	}

	public Image getColumnImage(Object element, int columnIndex) {
		// TODO Auto-generated method stub
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof Resource) {
			Resource r = (Resource) element;
			return r.getName();
		}
		return "UNKNOWN";
	}

}

class ResourceLabelProvider implements ITableLabelProvider {

	public ResourceLabelProvider() {
	}

	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof Resource) {
			Resource r = (Resource) element;
			return r.getName();
		}
		return "UNKNOWN";
	}

	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

}

class ResourceFilter extends ViewerFilter {

	private String searchString;

	public void setSearchString(String searchString) {
		this.searchString = searchString;
	}

	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (searchString == null || searchString.length() == 0) {
			return true;
		}

		if (element instanceof String) {
			String s = (String) element;
			return s.startsWith(searchString);
		}
		else if (element instanceof Resource) {
			Resource r = (Resource) element;
			return r.getName().startsWith(searchString);
		}
		return true;
	}

}

public class ResultPage extends WizardPage {
	private Composite containerCO;
	private Table allResources;
	private Table unusedResources;
	private WizardInput input;
	private CheckboxTableViewer unusedResourcesTV;
	private TableViewer allResourcesTV;
	private TabFolder tabFolder;
	private TabItem allResourcesTI;
	private TabItem unusedResourcesTI;
	private AllResourcesLabelProvider arlp;
	private ResourceFilter allResourcesFilter;
	private ResourceFilter unusedResourcesFilter;

	public ResultPage(WizardInput _input) {
		super("Dependency Analyzer result");
		setTitle("Dependency Analyzer result");
		setDescription("This page shows result dependency analysis result. Tab All resources shows list of all resources of the project, used resources are in bold. Tab Unused resources shows list of unused resources. You can deselect resources by unchecking them. Selected resources will be deleted after clicking Finish button.");
		setControl(allResources);
		this.input = _input;
	}

	public void createControl(final Composite parent) {
		containerCO = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		containerCO.setLayout(layout);
		layout.numColumns = 1;

		tabFolder = new TabFolder(containerCO, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		allResourcesTI = new TabItem(tabFolder, SWT.NONE);
		allResourcesTI.setText("All resources");

		unusedResourcesTI = new TabItem(tabFolder, SWT.NONE);
		unusedResourcesTI.setText("Unused resources");

		arlp = new AllResourcesLabelProvider();
		allResourcesFilter = new ResourceFilter();
		unusedResourcesFilter = new ResourceFilter();

		Composite c1 = new Composite(tabFolder, SWT.NONE);
		c1.setLayout(new GridLayout(1, true));
		final Text allResourcesFilterText = new Text(c1, SWT.BORDER | SWT.SEARCH);
		allResourcesTV = new TableViewer(c1, SWT.SINGLE | SWT.BORDER);

		allResourcesFilterText.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		allResourcesFilterText.addKeyListener(new KeyListener() {

			public void keyReleased(KeyEvent e) {
				allResourcesFilter.setSearchString(allResourcesFilterText.getText());
				allResourcesTV.refresh();
			}

			public void keyPressed(KeyEvent e) {
				allResourcesFilter.setSearchString(allResourcesFilterText.getText());
				allResourcesTV.refresh();
			}
		});


		allResourcesTV.setContentProvider(new ArrayContentProvider());
		allResourcesTV.setLabelProvider(arlp);
		allResourcesTV.addFilter(allResourcesFilter);
		allResources = allResourcesTV.getTable();
		allResources.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));	

		Composite c3 = new Composite(tabFolder, SWT.SCROLL_PAGE | SWT.SCROLL_LINE);
		GridLayout gl = new GridLayout(1, true);
		c3.setLayout(gl);
		unusedResourcesTV = CheckboxTableViewer.newCheckList(c3, SWT.CHECK | SWT.SINGLE | SWT.BORDER);
		unusedResourcesTV.setContentProvider(new ArrayContentProvider());
		unusedResourcesTV.setLabelProvider(new ResourceLabelProvider());
		unusedResourcesTV.addFilter(unusedResourcesFilter);
		unusedResources = unusedResourcesTV.getTable();
		unusedResources.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));				

		final Text unusedFilterText = new Text(c3, SWT.BORDER | SWT.SEARCH);

		unusedFilterText.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		unusedFilterText.addKeyListener(new KeyListener() {

			public void keyReleased(KeyEvent e) {
				unusedResourcesFilter.setSearchString(unusedFilterText.getText());
				unusedResourcesTV.refresh();
			}

			public void keyPressed(KeyEvent e) {
				unusedResourcesFilter.setSearchString(unusedFilterText.getText());
				unusedResourcesTV.refresh();
			}
		});		

		allResourcesTI.setControl(c1);
		unusedResourcesTI.setControl(c3);

		input.addListener(new WizardInputChangedListener() {
			public void inputChanged() {
				if (input.getEntryPoint() == null) {
					return;
				}
				try {
					refresh();
				}
				catch (Exception e) {
					
				}
			}

		});		
		
		setControl(containerCO);
		setPageComplete(true);

	}

	public Object[] getCheckedElements() {
		return unusedResourcesTV.getCheckedElements();
	}
	
	public void refresh() {
		Collection<Resource> usedResources = input.getProject().getUsedResources(input.getEntryPoint());
		Collection<Resource> unusedResources = input.getProject().getUnusedResources(input.getEntryPoint());
		Collection<Resource> allResources = input.getProject().getAllResources();
		
		System.out.println(usedResources.size() + " " + unusedResources.size() + " " + allResources.size());

		Resource[] usedResourcesI = usedResources.toArray(new Resource[usedResources.size()]);
		Arrays.sort(usedResourcesI);
		arlp.setUsedResources(usedResourcesI);


		Resource[] unusedResourcesI = unusedResources.toArray(new Resource[unusedResources.size()]);
		Arrays.sort(unusedResourcesI);
		unusedResourcesTV.setInput(unusedResourcesI);
		unusedResourcesTV.refresh();
		unusedResourcesTV.setAllChecked(true);

		Resource[] allResourcesI = allResources.toArray(new Resource[allResources.size()]);
		Arrays.sort(allResourcesI);
		allResourcesTV.setInput(allResourcesI);
		allResourcesTV.refresh();		
		
		setMessage("By clicking on Finish button you can violate the licences' terms of conditions of included libraries!", WizardPage.WARNING);
		
		if (input.getProject().isReflectionUsed()) {
			setErrorMessage("Use of Java Reflection API was detected in this project. By clicking on Finish button you risk deleting important resources!");
		}
	}
	
	@Override
	public void setVisible(boolean visible) {
		   super.setVisible(visible);
		   if (visible) {
		      refresh();
		   }
		}
}
